
#include "lib_activeobjectmanager.h"
#include "ge_autoptr.h"
#include "c4d_baselist.h"


#define LIBID			LIBRARY_ACTIVEOBJECTMANAGER
#define LIB				ActiveObjectManagerLib


static LIB *library = NULL;


static LIB *CheckLibObjectList(LONG offset)
{
	return (LIB*)CheckLib(LIBID,offset,(C4DLibrary**)&library);
}


Bool ActiveObjectManager_RegisterMode(ACTIVEOBJECTMODE id,const String &text,MESSAGEHOOK *hook)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,RegisterMode)); if (!lib || !lib->RegisterMode) return FALSE;
	return lib->RegisterMode(id,text,hook);
}

void ActiveObjectManager_SetMode(ACTIVEOBJECTMODE id,Bool openmanager)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,SetMode)); if (!lib || !lib->SetMode) return;
	lib->SetMode(id,openmanager);
}

void ActiveObjectManager_SetObjects(ACTIVEOBJECTMODE id,AtomArray &objects,Bool openmanager)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,SetObjects)); if (!lib || !lib->SetObjects) return;
	lib->SetObjects(id,objects,openmanager);
}

void ActiveObjectManager_SetObject(ACTIVEOBJECTMODE id,Atom *op,Bool openmanager)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,SetObjects)); if (!lib || !lib->SetObjects) return;
	AutoAlloc<AtomArray> objects; if (!objects) return;
	objects->Append(op);
	lib->SetObjects(id,objects,openmanager);
}

Bool ActiveObjectManager_GetObjects(ACTIVEOBJECTMODE id,AtomArray &objects)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,GetObjects)); if (!lib || !lib->GetObjects) return FALSE;
	return lib->GetObjects(id,objects);
}

Bool ActiveObjectManager_GetModeInfo(ACTIVEOBJECTMODE id,ActiveModeInfo &info)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,GetModeInfo)); if (!lib || !lib->GetModeInfo) return FALSE;
	return lib->GetModeInfo(id,info);
}

LONG ActiveObjectManager_GetModeCount()
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,GetModeCount)); if (!lib || !lib->GetModeCount) return FALSE;
	return lib->GetModeCount();
}

Bool ActiveObjectManager_GetModeInfoIdx(LONG idx,ActiveModeInfo &info)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,GetModeInfoIdx)); if (!lib || !lib->GetModeInfoIdx) return FALSE;
	return lib->GetModeInfoIdx(idx,info);
}

ACTIVEOBJECTMODE ActiveObjectManager_GetLastMode()
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,GetLastMode)); if (!lib || !lib->GetLastMode) return ACTIVEOBJECTMODE_NONE;
	return lib->GetLastMode();
}

void ActiveObjectManager_Open()
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,Open)); if (!lib || !lib->Open) return;
	lib->Open();
}

Bool EditObjectModal(const AtomArray &objects,const String &dlgtitle)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,EditObjectModal)); if (!lib || !lib->EditObjectModal) return FALSE;
	return lib->EditObjectModal(objects,dlgtitle);
}

Bool EditObjectModal(Atom *op,const String &dlgtitle)
{
	if (!op) return FALSE;
	AutoAlloc<AtomArray> objects; if (!objects) return FALSE;
	objects->Append(op);
	return EditObjectModal(objects,dlgtitle);
}

Bool EditDescription(DynamicDescription *dd,BaseContainer &bc)
{
	LIB *lib = CheckLibObjectList(LIBOFFSET(LIB,EditDescription)); if (!lib || !lib->EditDescription) return FALSE;
	return lib->EditDescription(dd,bc);
}
